
-- Headcrab canister SWEP
-- (c) phenex

_OpenScript( "includes/defines.lua" )
_OpenScript( "includes/vector3.lua" )
_OpenScript( "includes/misc.lua" )

MyIndex				=	0 -- Weapon's entity index.
Owner				= 	0 -- The player that owns this weapon
CurrentTime			=	0 -- The current game time

HeadCrabType = 0

-- Called when the weapon is created.
function onInit( )
	_RunString( [[
		math.randomseed( _CurTime( ) ) 
		
		TRACELINE_DIDHITSKY_TRUE = 4
		TRACELINE_DIDHITSKY_FALSE = 0
		
		px = px or { }
		px.canister = px.canister or { }
		px.canister.userlist = px.canister.userlist or { }
		px.canister.entlist = px.canister.entlist or { }

		px.canister.canPlayerFire = px.canister.canPlayerFire or
			function( playerid )
				if px.canister.userlist[playerid] < 1000 then
					return true
				else
					return false
				end
			end
	
		if px.canister.onthink_id == nil then
			px.canister.onthink = function( )
					for k,v in px.canister.entlist do
						if v ~= nil then							
							if _EntExists( k ) and _EntGetType( k ) == "env_headcrabcanister" then
								if v.time < _CurTime( ) then
									if v.action == "open" then
										_EntFire( k, "OpenCanister", "", 0 )
										
										v.action = "spawn"
										v.time = _CurTime( ) + 1.5
									elseif v.action == "spawn" then
										_EntFire( k, "SpawnHeadcrabs", "", 0 )
										
										v.action = "remove"
										
										-- Recommend a fixed time delay of 2 seconds plus 2 seconds for each headcrab in the canister.
										v.time = _CurTime( ) + 10
									elseif v.action == "remove" then
										_EntRemove( k )
										
										local playerid = px.canister.entlist[k].playerid
										px.canister.userlist[playerid] = math.max( 0, px.canister.userlist[playerid] - 1 )
										
										px.canister.entlist[k] = nil
										table.remove( px.canister.entlist, k )
									end
								end
							else
								local playerid = px.canister.entlist[k].playerid
								px.canister.userlist[playerid] = math.max( 0, px.canister.userlist[playerid] - 1 )
								
								px.canister.entlist[k] = nil
								table.remove( px.canister.entlist, k )
							end
						end
					end
				end
				
			px.canister.onthink_id = table.getn( gLuaThinkFunctions ) + 1 
			AddThinkFunction( px.canister.onthink )
		end
		
		if px.canister.event_propbreak == nil then
			px.canister.event_propbreak = function( breakerid, propid )
				if px.canister.entlist[propid] ~= nil then
					local playerid = px.canister.entlist[propid].playerid
					px.canister.userlist[playerid] = math.max( 0, px.canister.userlist[playerid] - 1 )
					
					px.canister.entlist[propid] = nil
					table.remove( px.canister.entlist, propid )
				end
			end
			
			HookEvent( "eventPropBreak", px.canister.event_propbreak )
		end
		
		px.canister.spawn = px.canister.spawn or
			function( playerid, headcrabtype )
				if px.canister.canPlayerFire( playerid ) == false then return nil end
				
				_TraceLine( _PlayerGetShootPos( playerid ), _PlayerGetShootAng( playerid ), 16384, playerid )
				local hitpos = _TraceEndPos( )

				local angvec

				for i=1,10 do
					angvec = vecNormalize( vector3( math.random( -5, 5 ), math.random( -5, 5 ), 20 ) )
					_TraceLine( hitpos, angvec, 32768 )

					if _TraceDidHitSky( ) == TRACELINE_DIDHITSKY_TRUE then break end
				end

				if _TraceDidHitSky( ) == TRACELINE_DIDHITSKY_FALSE then
					angvec = vector3( 0, 0, 1 )
					_TraceLine( hitpos, angvec, 32768 )

					if _TraceDidHitSky( ) == TRACELINE_DIDHITSKY_FALSE then
						_PrintMessage( playerid, 3, " * weapon_canister: Couldn't find a suitable angle to launch. Try getting \"more\" outdoors.\n" )
						return nil
					end
				end

				local spawnpos = _TraceEndPos( )
				local spawnheight = spawnpos.z - hitpos.z + 266

				local ent = _EntCreate( "env_headcrabcanister" )

				_EntSetPos( ent, hitpos )
				_EntSetAng( ent, angvec )

				_EntSetOwner( ent, Owner )

				_EntSetKeyValue( ent, "FlightSpeed", "10000" )
				_EntSetKeyValue( ent, "FlightTime", "5" )

				_EntSetKeyValue( ent, "StartingHeight", spawnheight )

				_EntSetKeyValue( ent, "SkyboxcanisterCount", 1 )

				_EntSetKeyValue( ent, "spawnflags", 8192 + 16384 + 32768 )

				_EntSetKeyValue( ent, "HeadcrabType", tonumber( headcrabtype ) )
				_EntSetKeyValue( ent, "HeadcrabCount", 0 )

				_EntSetKeyValue( ent, "Damage", 350 )
				_EntSetKeyValue( ent, "DamageRadius", 950 )

				_EntSpawn( ent )

				_EntFire( ent, "FireCanister", "", 1 )

				px.canister.entlist[ent] = { ["playerid"] = playerid, time = _CurTime( ) + 8, action = "open" }
				px.canister.userlist[playerid] = px.canister.userlist[playerid] + 1
			end
	]] )
end

-- Called when player picks up weapon
function onPickup( playerid )
	_RunString( [[
		if px.canister.userlist[]] .. tostring( playerid ) .. [[] == nil then
			px.canister.userlist[]] .. tostring( playerid ) .. [[] = 0
		end
	]] )
end
	
-- When the player presses left mouse button
function onPrimaryAttack( )
	if ( _PlayerInfo( Owner, "alive" ) == false ) then return nil end 
	
	_RunString( string.format( "px.canister.spawn( %d, %d )", Owner, HeadCrabType ) )
end

-- When player presses reload. Returning false means DON'T RELOAD. Although this will hitch on the client.
function onReload( )
	return true
end

-- Primary Attack Settings
function getDamage()
	return 0
end

function getPrimaryShotDelay()
	return 0.2
end

function getPrimaryIsAutomatic()
	return false
end

function getBulletSpread()
	return vector3( 0, 0, 0 )
end

function getViewKick()
	return vector3( 0, 0, 0 )
end

function getViewKickRandom()
	return vector3( 0, 0, 0 )
end

function getNumShotsPrimary()
	return 0
end

function getPrimaryAmmoType()
	return "pistol"
end

function getMaxClipPrimary() -- return -1 if it doesn't use clips
	return -1
end
	
function getDefClipPrimary() -- ammo in gun by default
	return 0
end
	
-- 0 = none, 1 = every bullet, 2 = every 2nd bullet etc
function getTracerFreqPrimary()
	return 1
end
	
-- Secondary attack Settings
function getDamageSecondary()
	return 0
end

function getSecondaryShotDelay()
	return 10
end

function getSecondaryIsAutomatic()
	return false;
end

function getBulletSpreadSecondary()
	return vector3( 0, 0, 0 )
end

function getViewKickSecondary()
	return vector3( 0, 0, 0)
end

function getViewKickRandomSecondary()
	return vector3( 0, 0, 0 )
end

function getNumShotsSecondary()
	return 0
end

function getSecondaryAmmoType()
	return "pistol"
end

function getMaxClipSecondary() -- return -1 if it doesn't use clips
	return -1
end

function getDefClipSecondary()
	return 0
end
	
function getTracerFreqSecondary()
	return 0
end
	
-- Weapon Configuration
function getViewModel( )
	return "models/weapons/v_smg_ump45.mdl"
end

function getWorldModel( )
	return "models/weapons/w_smg_ump45.mdl"
end

function getClassName() 
	return "weapon_artillery"
end

function getHUDMaterial( )
	return "gmod/SWEP/default"
end

function getDeathIcon( )
	return "swep_default"
end

function getWeaponSwapHands()
	return false	
end

function getWeaponFOV()
	return 70
end

function getWeaponSlot()
	return 5	
end

function getWeaponSlotPos()
	return 2
end

function getFiresUnderwater()
	return true
end

function getReloadsSingly()
	return false
end
	
-- How the player model holds the weapon: 
-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
function getAnimPrefix() 
	return "shotgun"
end

function getPrint()
	return "Artillery"
end

-- 0 = Don't override, shoot bullets, make sound and flash
-- 1 = Don't shoot bullets but do make flash/sounds
-- 2 = Only play animations
-- 3 = Don't do anything
function getPrimaryScriptOverride()
	return 2
end

function getSecondaryScriptOverride()
	return 3
end
